//								EJEMPLO 10
//						Autor: Mikel Etxebarria
//			(c) Ingeniera de Microsistemas Programados S.L.
//						www.microcontroladores.com
//								Bilbao 2006
//
//La interrupcin externa RBO/INT y el modo sleep.

//Se trata de comprobar la interrupcin externa que se aplica a travs del pin RBO/INT
//El programa principal est en un ciclo cerrado en modo SLEEP (standby de bajo consumo). Cada vez que
//se detecta un flanco descendente en RB0 se provoca una interrupcin cuyo tratamiento hace iluminar 
//las salidas RB7-RB1 durante 1 seg.

#include <16f876A.h>

//Ajusta los valores de la palabra de configuracin durante el ensamblaje:
//Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

#fuses NOPROTECT,NOCPD,NOLVP,NOWDT,XT

// Con estas directivas las funciones "input" y "output_bit" no reprograman
// el pin de la puerta cada vez que son utilizadas. Si no se indica el
// modo fast_io se asume por defecto standard_io el cual reprograma el pin
// siempre antes de ser utilizadas estas funciones.

#use delay(clock=4000000) //Activa las temporizaciones en base al clock de trabajo
#use fast_io (A)
#use fast_io (B)

#INT_EXT				//Inicio del tratamiento de interrupcin externa	
Tratamiento_ext()		// Funcin de tratamiento de interrupcin externa
{
	output_b(0xfe);		//Activa las salidas
	delay_ms(1000);		//Temporiza 1 segundo
	output_b(0x00);		//Desactivas salidas
}

main()
{  
	set_tris_b(0x01);				//RB0/INT entrada, resto salidas	   
	output_b (0x00);				//Borra las salidas
	ext_int_edge(H_to_L);			//Selecciona flanco descendente activo
  	enable_interrupts(INT_EXT);		// Seleccionar interrupciones por rebasamiento de TMR0
 	enable_interrupts(GLOBAL);		// Activar interrupciones

}	



